<?php

namespace Core;

class Session
{
    public static function start()
    {
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
    }
    
    public static function set($key, $value)
    {
        self::start();
        $_SESSION[$key] = $value;
    }
    
    public static function get($key, $default = null)
    {
        self::start();
        return $_SESSION[$key] ?? $default;
    }
    
    public static function has($key)
    {
        self::start();
        return isset($_SESSION[$key]);
    }
    
    public static function remove($key)
    {
        self::start();
        if (isset($_SESSION[$key])) {
            unset($_SESSION[$key]);
        }
    }
    
    public static function destroy()
    {
        self::start();
        session_destroy();
        $_SESSION = [];
    }
    
    public static function flash($key, $value = null)
    {
        self::start();
        
        if ($value === null) {
            $flashValue = self::get($key);
            self::remove($key);
            return $flashValue;
        }
        
        self::set($key, $value);
    }
    
    public static function setOldInput($data)
    {
        self::set('old_input', $data);
    }
    
    public static function getOldInput($key = null)
    {
        $oldInput = self::get('old_input', []);
        
        if ($key === null) {
            return $oldInput;
        }
        
        return $oldInput[$key] ?? null;
    }
    
    public static function clearOldInput()
    {
        self::remove('old_input');
    }
    
    public static function regenerate()
    {
        self::start();
        session_regenerate_id(true);
    }
    
    public static function csrfToken()
    {
        self::start();
        
        if (!self::has('csrf_token')) {
            self::set('csrf_token', bin2hex(random_bytes(32)));
        }
        
        return self::get('csrf_token');
    }
    
    public static function verifyCsrfToken($token)
    {
        return hash_equals(self::csrfToken(), $token);
    }
}
