<?php

return [
    // WhatsApp Business API Configuration
    'phone_number_id' => getenv('WA_PHONE_NUMBER_ID') ?: '',
    'business_account_id' => getenv('WA_BUSINESS_ACCOUNT_ID') ?: '',
    'access_token' => getenv('WA_ACCESS_TOKEN') ?: '',
    'webhook_verify_token' => getenv('WA_WEBHOOK_VERIFY_TOKEN') ?: '',
    'app_secret' => getenv('WA_APP_SECRET') ?: '',
    
    // API Endpoints
    'api_version' => 'v21.0',
    'base_url' => 'https://graph.facebook.com',
    
    // Webhook Configuration
    'webhook_url' => getenv('WA_WEBHOOK_URL') ?: '',
    
    // Rate Limiting
    'rate_limit' => [
        'messages_per_second' => 80,
        'messages_per_day' => 100000,
    ],
    
    // Message Templates
    'template_namespace' => getenv('WA_TEMPLATE_NAMESPACE') ?: '',
    
    // Media Settings
    'allowed_media_types' => [
        'image' => ['image/jpeg', 'image/png'],
        'video' => ['video/mp4', 'video/3gpp'],
        'audio' => ['audio/aac', 'audio/mp4', 'audio/mpeg', 'audio/amr', 'audio/ogg'],
        'document' => ['application/pdf', 'application/vnd.ms-excel', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'application/vnd.ms-powerpoint', 'application/vnd.openxmlformats-officedocument.presentationml.presentation', 'text/plain'],
    ],
    
    'max_media_size' => [
        'image' => 5 * 1024 * 1024, // 5MB
        'video' => 16 * 1024 * 1024, // 16MB
        'audio' => 16 * 1024 * 1024, // 16MB
        'document' => 100 * 1024 * 1024, // 100MB
    ],
];
