<?php

return [
    // Payment Gateways
    'gateways' => [
        'bank_transfer' => [
            'enabled' => true,
            'name' => 'Bank Transfer',
            'instructions' => 'Please transfer to the following account and upload proof of payment.',
            'accounts' => [
                [
                    'bank_name' => 'Your Bank Name',
                    'account_number' => '123456789',
                    'account_name' => 'Sender Platform',
                ],
            ],
        ],
        
        'mtn_momo' => [
            'enabled' => true,
            'name' => 'MTN Mobile Money',
            'merchant_code' => getenv('MTN_MERCHANT_CODE') ?: '',
            'api_key' => getenv('MTN_API_KEY') ?: '',
            'api_secret' => getenv('MTN_API_SECRET') ?: '',
            'sandbox' => getenv('MTN_SANDBOX') === 'true',
        ],
        
        'orange_money' => [
            'enabled' => true,
            'name' => 'Orange Money',
            'merchant_id' => getenv('ORANGE_MERCHANT_ID') ?: '',
            'api_key' => getenv('ORANGE_API_KEY') ?: '',
            'api_secret' => getenv('ORANGE_API_SECRET') ?: '',
            'sandbox' => getenv('ORANGE_SANDBOX') === 'true',
        ],
    ],
    
    // Subscription Plans (Pricing in CFA - Central African Franc)
    // Based on respond.io pricing structure
    'plans' => [
        'starter' => [
            'name' => 'Starter',
            'price_monthly' => 39000, // ~$65 USD converted to CFA
            'price_yearly' => 390000, // ~$650 USD converted to CFA (2 months free)
            'features' => [
                'contacts' => 1000,
                'messages_per_month' => 5000,
                'users' => 2,
                'templates' => 10,
                'campaigns' => 20,
                'analytics' => true,
                'inbox' => true,
                'api_access' => false,
                'priority_support' => false,
            ],
        ],
        
        'professional' => [
            'name' => 'Professional',
            'price_monthly' => 99000, // ~$165 USD converted to CFA
            'price_yearly' => 990000, // ~$1,650 USD converted to CFA (2 months free)
            'features' => [
                'contacts' => 10000,
                'messages_per_month' => 25000,
                'users' => 5,
                'templates' => 50,
                'campaigns' => 100,
                'analytics' => true,
                'inbox' => true,
                'api_access' => true,
                'priority_support' => false,
            ],
        ],
        
        'business' => [
            'name' => 'Business',
            'price_monthly' => 199000, // ~$330 USD converted to CFA
            'price_yearly' => 1990000, // ~$3,300 USD converted to CFA (2 months free)
            'features' => [
                'contacts' => 50000,
                'messages_per_month' => 100000,
                'users' => 10,
                'templates' => 100,
                'campaigns' => -1, // unlimited
                'analytics' => true,
                'inbox' => true,
                'api_access' => true,
                'priority_support' => true,
            ],
        ],
        
        'enterprise' => [
            'name' => 'Enterprise',
            'price_monthly' => 0, // Custom pricing
            'price_yearly' => 0,
            'features' => [
                'contacts' => -1, // unlimited
                'messages_per_month' => -1, // unlimited
                'users' => -1, // unlimited
                'templates' => -1, // unlimited
                'campaigns' => -1, // unlimited
                'analytics' => true,
                'inbox' => true,
                'api_access' => true,
                'priority_support' => true,
                'dedicated_support' => true,
                'custom_integration' => true,
            ],
        ],
    ],
    
    // Additional message credits pricing (for when monthly limit is exceeded)
    'message_credits' => [
        '1000' => 5000, // 1000 messages for 5,000 CFA
        '5000' => 20000, // 5000 messages for 20,000 CFA
        '10000' => 35000, // 10000 messages for 35,000 CFA
        '25000' => 80000, // 25000 messages for 80,000 CFA
        '50000' => 150000, // 50000 messages for 150,000 CFA
    ],
    
    // Free trial
    'trial' => [
        'enabled' => true,
        'duration_days' => 14,
        'plan' => 'starter',
    ],
    
    // Currency
    'currency' => [
        'code' => 'XAF',
        'symbol' => 'FCFA',
        'position' => 'after', // before or after amount
    ],
];
