# Sender - WhatsApp Bulk Messaging Platform

A professional WhatsApp bulk messaging platform built with PHP using MVP architecture, inspired by respond.io. Designed for the Cameroonian market with CFA pricing and local payment methods.

## Features

✅ **Contact Management**
- Import contacts from CSV/Excel
- Extract contacts from WhatsApp groups
- Contact segmentation
- Export functionality

✅ **Template Management**
- Create and manage message templates
- Variable substitution
- Media support (images, videos, documents)
- Template approval workflow

✅ **Campaign System**
- Visual campaign builder
- Schedule campaigns
- Bulk sending with queue system
- Real-time monitoring

✅ **Inbox & Conversations**
- Unified inbox for all conversations
- Reply to incoming messages
- Conversation assignment
- Message history

✅ **Analytics & Reporting**
- Dashboard with key metrics
- Campaign performance reports
- Delivery statistics
- Export reports

✅ **Billing & Subscriptions**
- Pricing in CFA (Central African Franc)
- MTN Mobile Money integration
- Orange Money integration
- Bank transfer support
- Multiple subscription plans

✅ **Admin Panel**
- User management
- Feature toggles
- Payment verification
- System settings

## Requirements

- PHP 8.1 or higher
- MySQL 8.0 or higher
- Apache/Nginx with mod_rewrite
- SSL certificate (required for WhatsApp webhooks)
- Cron job access
- WhatsApp Business API credentials

### PHP Extensions Required
- pdo_mysql
- curl
- gd
- mbstring
- json
- openssl

## Installation

### 1. Download & Extract

```bash
# Clone or download the repository
git clone https://github.com/yourusername/sender-app.git
cd sender-app
```

### 2. Install Dependencies

```bash
composer install
```

### 3. Set Permissions

```bash
chmod 755 storage/logs
chmod 755 public/uploads
```

### 4. Run Installation Wizard

Navigate to: `http://yourdomain.com/install/`

The wizard will guide you through:
- System requirements check
- Database configuration
- WhatsApp API setup
- Admin account creation

### 5. Configure Cron Jobs

Add these cron jobs:

```bash
# Process message queue every minute
*/1 * * * * php /path/to/sender-app/cron/process-queue.php >> /path/to/sender-app/storage/logs/cron.log 2>&1

# Daily cleanup at 2 AM
0 2 * * * php /path/to/sender-app/cron/cleanup.php >> /path/to/sender-app/storage/logs/cleanup.log 2>&1
```

### 6. Configure WhatsApp Webhook

In your Meta for Developers dashboard:
- **Webhook URL**: `https://yourdomain.com/public/webhook/whatsapp`
- **Verify Token**: Use the token generated during installation

## WhatsApp API Setup

### Getting Your Credentials

1. **Create Meta Business Account**
   - Visit: https://business.facebook.com/
   - Create and verify your business account

2. **Create Developer App**
   - Visit: https://developers.facebook.com/
   - Create new app → Business → WhatsApp
   - Add WhatsApp product

3. **Get Credentials**
   - Phone Number ID: WhatsApp Manager → Phone Numbers
   - Business Account ID: WhatsApp Manager → Account Info
   - Access Token: App Dashboard → WhatsApp → API Setup
   - Create Webhook Verify Token (auto-generated during install)

4. **Configure Webhook**
   - Callback URL: `https://yourdomain.com/public/webhook/whatsapp`
   - Verify Token: From installation
   - Subscribe to: messages, message_status

### Useful Links
- [WhatsApp Cloud API Documentation](https://developers.facebook.com/docs/whatsapp/cloud-api)
- [Meta for Developers](https://developers.facebook.com/)
- [WhatsApp Business Manager](https://business.facebook.com/wa/manage/)

## Configuration

### Environment Variables

Create a `.env` file (or configure during installation):

```env
# App
APP_ENV=production
APP_DEBUG=false
APP_URL=https://yourdomain.com
APP_KEY=your-encryption-key

# Database
DB_HOST=localhost
DB_NAME=sender_db
DB_USER=root
DB_PASS=

# WhatsApp API
WA_PHONE_NUMBER_ID=your-phone-number-id
WA_BUSINESS_ACCOUNT_ID=your-business-account-id
WA_ACCESS_TOKEN=your-access-token
WA_WEBHOOK_VERIFY_TOKEN=your-webhook-token

# Email (for password recovery)
MAIL_DRIVER=smtp
MAIL_HOST=smtp.example.com
MAIL_PORT=587
MAIL_USERNAME=
MAIL_PASSWORD=
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=noreply@yourdomain.com
MAIL_FROM_NAME=Sender

# Payment Gateways
MTN_MERCHANT_CODE=
MTN_API_KEY=
MTN_API_SECRET=
MTN_SANDBOX=true

ORANGE_MERCHANT_ID=
ORANGE_API_KEY=
ORANGE_API_SECRET=
ORANGE_SANDBOX=true
```

## Pricing Plans (CFA)

### Starter Plan
- **Price**: 39,000 FCFA/month or 390,000 FCFA/year
- 1,000 contacts
- 5,000 messages/month
- 2 users
- 10 templates

### Professional Plan
- **Price**: 99,000 FCFA/month or 990,000 FCFA/year
- 10,000 contacts
- 25,000 messages/month
- 5 users
- 50 templates
- API access

### Business Plan
- **Price**: 199,000 FCFA/month or 1,990,000 FCFA/year
- 50,000 contacts
- 100,000 messages/month
- 10 users
- 100 templates
- API access
- Priority support

### Enterprise Plan
- **Custom pricing**
- Unlimited contacts
- Unlimited messages
- Unlimited users
- Unlimited templates
- Dedicated support

## Usage

### Creating a Campaign

1. **Create a Template**
   - Navigate to Templates → Create New
   - Design your message with variables
   - Submit for approval (if required)

2. **Import Contacts**
   - Go to Contacts → Import
   - Upload CSV/Excel file
   - Map fields and import

3. **Create Campaign**
   - Campaigns → Create New
   - Select template
   - Choose recipients (groups/segments)
   - Schedule or send immediately

4. **Monitor Progress**
   - View real-time delivery status
   - Check analytics dashboard
   - Export reports

### Managing Inbox

- View all incoming messages
- Reply to conversations
- Assign conversations to team members
- Mark conversations as closed

## Payment Methods

### MTN Mobile Money
1. User initiates payment
2. Receives MTN prompt on phone
3. Enters PIN to complete
4. System auto-verifies payment

### Orange Money
1. User initiates payment
2. Receives Orange prompt on phone
3. Enters PIN to complete
4. System auto-verifies payment

### Bank Transfer
1. User selects bank transfer
2. Views bank account details
3. Makes transfer
4. Uploads proof of payment
5. Admin verifies and approves

## Security

- Passwords hashed with bcrypt
- SQL injection prevention (PDO prepared statements)
- CSRF protection on forms
- XSS prevention in views
- Rate limiting on API endpoints
- File upload validation
- SSL/TLS encryption required

## Troubleshooting

### Messages Not Sending
- Check WhatsApp API credentials
- Verify phone number is registered
- Check rate limits
- Review error logs in `storage/logs/`

### Webhook Not Working
- Ensure URL is HTTPS
- Verify token matches
- Check firewall rules
- Test with WhatsApp API test tool

### Queue Not Processing
- Verify cron job is running
- Check cron logs
- Ensure database connection
- Review queue settings

### Payment Issues
- Verify gateway credentials
- Check sandbox/production mode
- Review payment webhooks
- Check transaction logs

## Support

For issues or questions:
1. Check the [Implementation Guide](IMPLEMENTATION_GUIDE.md)
2. Review error logs in `storage/logs/`
3. Verify WhatsApp API status
4. Check Meta for Developers community

## License

Proprietary - All rights reserved

## Credits

Built with PHP using MVP architecture pattern.
Inspired by respond.io.
Designed for the Cameroonian market.

---

**Version**: 1.0.0
**Last Updated**: February 2026
